<?php

namespace Database\Seeders;

use App\Models\Locale;
use App\Models\SiteConfiguration;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class CurrencySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('currencies')->truncate();
        $currencies = [
            [
                'short_code' => 'USD',
                'symbol' => '$',
                'name' => 'United States dollar',
                'country' => 'United States'
            ],
            [
                'short_code' => 'INR',
                'symbol' => '₹',
                'name' => 'Indian rupee',
                'country' => 'India'
            ],
            [
                'short_code' => 'AUD',
                'symbol' => 'AUD',
                'name' => 'Australian dollar',
                'country' => 'Australia'
            ],
            [
                'short_code' => 'BRL',
                'symbol' => 'R$',
                'name' => 'Brazilian real',
                'country' => 'Brazil'
            ],
            [
                'short_code' => 'CAD',
                'symbol' => 'CAD',
                'name' => 'Canadian dollar',
                'country' => 'Canada'
            ],
            [
                'short_code' => 'DKK',
                'symbol' => 'KR',
                'name' => 'Danish krone',
                'country' => 'Denmark',
            ],
            [
                'short_code' => 'EUR',
                'symbol' => '€',
                'name' => 'Euro',
                'country' => 'France'
            ],
            [
                'short_code' => 'HKD',
                'symbol' => 'HKD',
                'name' => 'Hong Kong dollar',
                'country' => 'Hong Kong'
            ],
            [
                'short_code' => 'ILS',
                'symbol' => '₪',
                'name' => 'Israeli new shekel',
                'country' => 'Israel'
            ],
            [
                'short_code' => 'MYR',
                'symbol' => 'RM',
                'name' => 'Malaysian ringgit',
                'country' => 'Malaysia'
            ],
            [
                'short_code' => 'MXN',
                'symbol' => 'MXN',
                'name' => 'Mexican peso',
                'country' => 'Mexico',

            ],
            [
                'short_code' => 'NZD',
                'symbol' => 'NZD',
                'name' => 'New Zealand dollar',
                'country' => 'New Zealand',

            ],
            [
                'short_code' => 'NOK',
                'symbol' => 'kr',
                'name' => 'Norwegian krone',
                'country' => 'Norway',
            ],
            [
                'short_code' => 'PHP',
                'symbol' => '₱',
                'name' => 'Philippine peso',
                'country' => 'Philippines',
            ],
            [
                'short_code' => 'PLN',
                'symbol' => 'zł',
                'name' => 'Polish złoty',
                'country' => 'Poland'
            ],
            [
                'short_code' => 'GBP',
                'symbol' => '£',
                'name' => '	British pound',
                'country' => 'United Kingdom'

            ],
            [
                'short_code' => 'RUB',
                'symbol' => 'RUB',
                'name' => 'Russian ruble',
                'country' => 'Russia'

            ],
            [
                'short_code' => 'SGD',
                'symbol' => 'SGD',
                'name' => 'Singapore dollar',
                'country' => 'Singapore'
            ],
            [
                'short_code' => 'SEK',
                'symbol' => 'SEK',
                'name' => 'Swedish krona',
                'country' => 'Sweden',
            ],
            [
                'short_code' => 'CHF',
                'symbol' => 'CHF',
                'name' => 'Swiss franc',
                'country' => 'Liechtenstein',
            ],
            [
                'short_code' => 'THB',
                'symbol' => '฿',
                'name' => 'Thai baht',
                'country' => 'Thailand'
            ]
        ];

        DB::table('currencies')->insert($currencies);
    }
}
